
//------------------------------------------------------------------------------------------------
// Defines
//------------------------------------------------------------------------------------------------

#define 	INTERPOLATE_FILM_GRAIN_NOISE
#define 	ADDITIVE_FILM_GRAIN_BLEND
#define		LOW_BIAS
#define		g_ViewportScaleBias		vs_viewportScaleBias		// viewport scale xy, offset xy


//------------------------------------------------------------------------------------------------
// Texture samplers
//------------------------------------------------------------------------------------------------

//@:-texformat colourTex RGBA8

sampler2D colourTex               : register(s5);

#if !defined(SAT_ONLY)
	sampler3D cubeTex             : register(s7);
#endif


//------------------------------------------------------------------------------------------------
// Shader constants
//------------------------------------------------------------------------------------------------

#if defined(SAT_ONLY)

	uniform float4 saturation      : register(c0);

#else // SM2 and SM3

	uniform float4 noiseOffset  : register(c28);  // {offset0.u,     offset0.v,     offset1.u,     offset1.v     } 
	uniform float4 noiseParams  : register(c29);  // {screenScale.u, screenScale.v, blendFactor,   noiseIntensity}
	uniform float4 noiseParams2 : register(c30);  // {grainDistort,  hdrRange,      unused,        unused        }

#endif


//------------------------------------------------------------------------------------------------
// Process Colour
//------------------------------------------------------------------------------------------------

#if !defined(SAT_ONLY)

half3 ProcessColourNoise(half2 NoiseTexCoords, half2 NoiseTexCoords2, half NoiseLerp)
{
	#if defined(INTERPOLATE_FILM_GRAIN_NOISE) && !defined(PAINT)
		return lerp(tex2D(noiseTex, NoiseTexCoords).rgb, tex2D(noiseTex, NoiseTexCoords2).rgb, NoiseLerp) - 0.5;
	#else
		return tex2D(noiseTex, NoiseTexCoords).rgb - 0.5;
	#endif
}

half4 ProcessColour( half4 colour, half3 noise, half ExposureNoise )
{
	// Get the raw film grain noise and shift, scale, blend and adjust its intensity.
	half luminance = dot(half3(0.30, 0.59, 0.11), colour.rgb);

	#if defined(LOW_BIAS)
		half intensityAdjustment = ExposureNoise * (1.0 - luminance * luminance);
	#endif
	#if defined(MIDRANGE_BIAS)
		half intensityAdjustment = ExposureNoise * 8.0 * (luminance - luminance * luminance);
	#endif
	#if defined(SLOPE_BIAS)
		half intensityAdjustment = ExposureNoise * (0.4 + luminance * 0.6);
	#endif

	noise *= intensityAdjustment;

	#if defined(ADDITIVE_FILM_GRAIN_BLEND)
		// Apply the film grain noise using an additive blend.
		colour.rgb = saturate(colour.rgb + noise);
	#else
		// Apply the film grain noise using an overlay blend.
		grainNoise0 += 0.5;
		half mixer = smoothstep(0.45, 0.55, luminance);
		half3 multiplyResult = colour.rgb * noise * 2.0;
		half3 screenResult = 1.0 - (1.0 - colour.rgb) * (1.0 - noise) * 2.0;
		colour.rgb = lerp(multiplyResult, screenResult, mixer);
	#endif

	// All colour processing is done via a 3D texture lookup.
	return tex3D(cubeTex, colour.rgb);
}

half4 ProcessColourPaint( half4 colour, half2 NoiseTexCoords, half intensityAdjustment )
{
	half2 satTintNoise = (tex2D(noiseTex, NoiseTexCoords * 0.33).gb - 0.5) * intensityAdjustment * half2(8.0, 1.0);

	// Modulate yellow-blue tint with noise.
	half3 colourAdjustment = half3(-satTintNoise.y, -satTintNoise.y, satTintNoise.y);
	half3 colourBalanceFactor = colour.rgb - colour.rgb * colour.rgb;
	colour.rgb += colourBalanceFactor * colourAdjustment;

	// Modulate saturation with noise.
	half luminance = dot(half3(0.30, 0.59, 0.11), colour.rgb);
	colour.rgb = luminance - (1.0 + satTintNoise.x) * (luminance - colour.rgb);

	// Modulate the brightness with noise to give a bump effect.
	half loNoise = tex2D(noiseTex, NoiseTexCoords + half2(0.0, 0.005)).b - 0.5;
	half hiNoise = tex2D(noiseTex, NoiseTexCoords).b - 0.5;
	colour.rgb = saturate(colour.rgb + intensityAdjustment * (hiNoise - loNoise));

	// All colour processing is done via a 3D texture lookup.
	return tex3D(cubeTex, colour.rgb);
}

#else // SAT_ONLY Shaders

half4 ProcessColour( half4 colour, float Saturation )
{
	// For shader 1.1 we only apply the saturation adjustment.
	half luminance = dot(half3(0.30, 0.59, 0.11), colour.rgb);
	return half4(luminance - saturation * (luminance - colour.rgb), colour.a);

	//half3 colourBalanceFactor = colour - colour * colour;
	//colour += colourBalanceFactor * colourAdjustmentSum;
}

#endif


